---
Note type: Zettel
tags:
  - "#Zettel"
Related areas:
  - "[[Research]]"
Related projects:
  - "[[Paper X]]"
Related tasks: 
Related MoCs: 
Related references:
  - "[[Islam 2012]]"
  - "[[Feenberg 1999]]"
  - "[[Feenberg 2017]]"
  - "[[Feenberg 2008]]"
  - "[[Feenberg 2011]]"
  - "[[Arnold & Michel 2017]]"
  - "[[Kavoulakos 2017]]"
  - "[[C Lawson 2017]]"
  - "[[Silva 2013]]"
  - "[[Denis, Dompierre, Langley & Rouleau 2011]]"
  - "[[Adams & Markus 2001]]"
  - "[[Bhaskar 1997]]"
  - "[[Suchman 1994]]"
Related zettels: 
Related meeting notes: 
Related resources: 
Related people:
  - "[[Andrew Feenberg]]"
  - "[[Axel Honneth]]"
  - "[[György Lukács]]"
  - "[[Theodor Adorno]]"
  - "[[Max Horkheimer]]"
  - "[[Jürgen Habermas]]"
  - "[[Peter L. Berger]]"
  - "[[Thomas Luckmann]]"
  - "[[Karl Marx]]"
aliases:
  - reify
  - reified
  - reifying
  - naturalization
  - naturalisation
  - naturalize
  - naturalise
  - naturalizing
  - naturalising
  - naturalized
  - naturalised
Creation date: 2024-05-27
Last modified: 2024-05-27
---

## Fleeting notes

### 2022-01-10

Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi quis arcu ac nibh rhoncus malesuada vel at ante. Maecenas et massa quis velit sagittis fermentum at et est. Nunc ullamcorper tincidunt justo. Etiam et sollicitudin diam. Curabitur quis elit faucibus ipsum consequat efficitur et nec orci. Etiam sapien lorem, semper non mauris vitae, faucibus volutpat libero. Curabitur bibendum, lectus nec ullamcorper egestas, dui mauris ullamcorper nibh, quis sollicitudin quam ipsum in neque. Sed varius accumsan mi, quis semper nulla sollicitudin et. Maecenas viverra turpis tempus felis viverra, rhoncus scelerisque tellus lacinia. Suspendisse euismod lobortis lacus, viverra condimentum enim luctus eu. Sed vel erat tincidunt, egestas ligula sit amet, euismod massa.

## General notes

### Definitions

"Practices of reification are aimed at achieving irreversibility by attributing symbolic value, importance, and immutability to the collective project. In contrast, practices of strategic ambiguity are aimed at making decisions acceptable to participants by creating “space” within which multiple interpretations by stakeholders are enabled” ([[Denis et al. 2011]], p. 236)

### Approaches to concept / schools of thought

#### [[Marxism|Marxist]] view of [[reification]] - Stanford Encyclopaedia of Philosophy

> In a section of Capital titled “The Fetishism of Commodities and the Secret Thereof”, Karl Marx argues that certain social categories that might appear natural are in fact the products of social and economic relations among people. A commodity, such as gold or coal or corn, has some natural properties, as well as some properties that are obviously attached to them by people. A commodity’s value is, according to Marx, a product of the labor it takes to produce it. The social character of individual labor, though, is hidden (Marx 1867). It might seem that a bushel of corn, as a component of our economic system, is a product of a farmer working the land. But Marx argues that commodities can only be understood in terms of social structures as a whole.
> Marx also argues that the sources of these structures are neither intellectual nor psychological. Instead, the ideological features of a society are determined by the material relations among people in that society, including technologies, systems of production, and relations of power.
> Marx himself is largely interested in describing these structures and the interactions among them. The discussion of commodities is a rare instance of an ontological claim by Marx. Subsequent philosophers, however, put claims of the constructedness of social entities at the center of social critique. Lukács 1923 argues that capitalism extensively “reifies” social entities—that is, it turns phenomena that arise from an oppressive economic system into features of the world that we regard as natural. Members of the Frankfurt School, especially Theodor Adorno and Max Horkheimer, build on Lukács to argue not just that the social world becomes “second nature” to us, but that the reification itself is part of the maintenance of the reified system. That is, our current social order is maintained, at least in part, by the causal effects of our treating social entities and categories as if they were natural (Adorno & Horkheimer 1947, Adorno 1966).

#### [[social constructivism|Social constructivist]] view of [[reification]] - [[Peter L. Berger]], [[Thomas Luckmann]], [[Pullberg]]

- “definition of reification that Berger and Luckmann present in their treatise The Social Construction of Reality:”
	 - “Reification is the apprehension of human phenomena as if they were things, that is, in non-human or possibly supra-human terms. Another way of saying this is that reification is the apprehension of the products of human activity as if they were something else than human products – such as facts of nature, results of cosmic laws, or manifestations of divine will. Reification implies that man is capable of forgetting his own authorship of the human world ... The reified world is, by definition, a dehumanized world. It is experienced by man as a strange facticity, an opus alienum over which he has no control rather than as the opus proprium of his own productive activity. (Berger and Luckmann, 1966: 82–3, italics in the original)” ([[Silva 2013]], p. 82)
- “the Hungarian Marxist philosopher and literary critic [[György Lukács]], the first scholar to fully develop the theoretical and political implications of reification, ultimately restricting this concept to the historical context of late capitalism (Lukacs, 1971).” ([[Silva 2013]], p. 81)
- “On one side, Marxian scholars have denounced reification as a misapprehension and a form of distorted praxis. On the other side, Whiteheadian scholars have defined reification (hypostatization) as the ‘fallacy of misplaced concreteness’, the name given by the mathematician and philosopher Alfred Whitehead (1925: 74–5) to the tendency among intellectuals to see their analytic concepts as autonomous things.” ([[Silva 2013]], p. 83)
- [[Berger and Pullberg 1965]] "describe reification as the final stage in a four-stage process”: ([[Silva 2013]], p. 84)
	 - “They call the first stage objectivation because, as they put it, we humans embody our intentionality in the products we create, from material objects to such abstractions as names.”
	 - “The second stage, objectification, happens at the point in the process of objectivation in which we distance ourselves from our products and take cognizance of them as objects of consciousness. Now, not only do we objectivate, but we also recognize our products as such.”
	 - “Later, in the stage of alienation, as the distance between us and our products continues to grow, we forget that we ourselves created those products, which now appear to us in consciousness as ‘alien facticities’.”
	 - “The fourth and last stage, reification, takes place when we begin to apprehend those things as not only alien but also real.”
- “In all times and places, human subjects are prone to reify. They do this by first abstracting from the concrete and then concretizing the abstract (Berger and Pullberg, 1965: 208).” ([[Silva 2013]], p. 84)

#### [[_ PKM/_ Zettelkasten/performativity|Performative]] understanding of [[reification]] - [[Judith Butler]]

- “the organization of patterns into reified identities is not simply a ‘subjective’ construal. In addition, the organization of patterns into reified identities is to some extent given in ‘objective’ reality. In other words, the reification of culture into group entities is often not illusory but is present in the structure of worlds that individuals inherit.” ([[Adams & Markus 2001]], p. 291)
- “Cultural identity categories—and the supposedly ‘defining features’ associated with these categories—are not ‘just so’; instead, they are the way they are because people make them so. Their reified fixedness is not natural or inevitable but is instead a social construction: the cumulative, material residue of the identity syntheses achieved by wave after wave of subjective selves.” ([[Adams & Markus 2001]], p. 291)
- “Despite common misconceptions, to say something is ‘socially constructed’ does not mean that it is optional or inconsequential. Instead inherited categories place very real, objective constraints on the identity-construction activities of the subjective self.” ([[Adams & Markus 2001]], p. 292)
 - “inherited categories provide the raw materials from which individuals construct personal identity. It is difficult to build a personal identity as a footballer if football is unknown in a setting.” ([[Adams & Markus 2001]], p. 292)
 - “inherited categories constrain identity construction by defining consensual reality. {...} individual attempts to claim certain identities are subject to ratification by social consensus.” ([[Adams & Markus 2001]], p. 292)

### Examples of [[reification]]

Reification of [[algorithms]]
- “{the workings of the network} mostly become ‘black boxed’ and as such become accepted, or taken for granted, as the way the world is—they gain an “aura of naturalness” as Ciborra and Lanzara 1994 suggest.” ([[Introna and Hayes 2011]], p. 110)
- "Algorithms are presented as objectively and mathematically correct and, as a result, people trust and abide by them (Lee, Kusbit, Metsky, & Dabbish, 2015)." ([[Duggan, Sherman, Carbery & McDonnell 2020]] p6) [[reification]] [[technocracy]]
- These algorithms and the big data they mobilize present themselves as "the market" and so "choices become framed as purely technical and mathematical concerns, and less so as moral issues." ([[Kuhn, Ashcraft & Cooren 2017]]) p16) - [[agency and technocracy]]

Reification of [[culture]]
- “the [[reification]] of culture—the tendency to turn names into things—may be inherent in the act of naming” ([[Adams & Markus 2001]], p. 285)
- “we propose that a more fundamental source of [[reification]] in the discipline of psychology is the prevailing tendency to equate culture with group.” ([[Adams & Markus 2001]], p. 286)
	- “It is largely due to an entity conception of culture that the act of naming promotes reification. {...} the turning of names into things requires the idea that the patterns being described correspond to some object—in this case, a group of people.” ([[Adams & Markus 2001]], p. 286)
- “In contrast to this reification-prone conception of culture as group entity, we borrow from a classic definition and advocate a less reifying conception of culture as patterns:” ([[Adams & Markus 2001]], p. 286)
	- “Culture consists of patterns, explicit and implicit, of and for behavior acquired and transmitted by symbols, constituting the distinctive achievement of human groups, including their embodiments of artifacts; the core of culture consists of traditional (i.e., historically derived and selected) ideas and especially their attached values; culture systems may, on one hand, be considered as products of actions and on the other hand as conditioning elements of further action. (Kroeber & Kluckhohn, 1952, p. 357, emphasis added)” ([[Adams & Markus 2001]], p. 287)
	- “This definition makes clear that culture resides not in groups themselves, but in the implicit and explicit patterns that are (often) associated with groups (cf. Sperber, 1984).”
	- “It frames cultural involvement not as membership in a more-or-less recognized group, but as engagement with patterns. Though an entity conception of culture tends to limit cultural influence to those people who are defined by (or in opposition to) some group, a conception of culture as patterns allows for broader, more diffuse influence. A person need not be a member of some cultural group to engage and be shaped by cultural patterns” ([[Adams & Markus 2001]], p. 287)
	 - Example: “the power of Protestantism to shape psychological functioning is not limited to members of Protestant groups. Instead, the more pervasive and enduring source of Protestantism’s power is as a cultural pattern. It is an often implicit, unrecognized part of the institutions, practices and artifacts that constitute everyday reality in mainstream American settings. In these settings, the legacy of Protestantism is embedded in the common ground for interaction and experience. Its legacy is present, for example, in the idea that success is the result of self-discipline and one’s own hard work, or in the relationship of control feelings and internal attributions to happiness and well-being (Ji, Peng, & Nisbett, 2000; Kluegel & Smith, 1986; Lachman & Weaver, 1998). Regardless of personal identity, people in mainstream American settings necessarily encounter this cultural legacy in the course of everyday activity. A person can fervently embrace cultural patterns associated with Catholicism but must simultaneously engage—often unwittingly—the Protestantism-informed patterns that dominate everyday reality in mainstream American settings. Clearly, a person need not be a member of a Protestant group to engage and be shaped by Protestant cultural patterns.” ([[Adams & Markus 2001]], p. 290)
